/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	RotateObjects.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CApplication.h"
#include "CEdit.h"

HRESULT RotateObjects(double angle, ISet *objectSet1)
{

//	Rotates the object set with the given angle
//	and returns the rotated object set

	START_METHOD("RotateObjects")

	HRESULT status = CONV_SUCCESS;
	
	double theta, cosTheta, sinTheta;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	theta = angle * PI / 180 ;
	cosTheta = cos(theta);
	sinTheta = sin(theta);

	IDirection *localX = NULL;
	status = activeWorkplane->GetLocalX(&localX);
	CHECK_RETURN_STATUS(status)

	IDirection *localY = NULL;
	status = activeWorkplane->GetLocalY(&localY);
	CHECK_RETURN_STATUS(status)

	IVector *new1X = NULL;
	status = localX->Multiply(cosTheta, &new1X);
	CHECK_RETURN_STATUS(status)

	IVector *new2X = NULL;
	status = localY->Multiply(sinTheta, &new2X);
	CHECK_RETURN_STATUS(status)

	IVector *new3X = NULL;
	status = new1X->Add(CAST(IVectorOrDirection, new2X), &new3X);
	CHECK_RETURN_STATUS(status)

	IVector *new1Y = NULL;
	status = localX->Multiply(-sinTheta, &new1Y);
	CHECK_RETURN_STATUS(status)

	IVector *new2Y = NULL;
	status = localY->Multiply(cosTheta, &new2Y);
	CHECK_RETURN_STATUS(status)

	IVector *new3Y = NULL;
	status = new1Y->Add(CAST(IVectorOrDirection, new2Y), &new3Y);
	CHECK_RETURN_STATUS(status)

	IMatrix *mat1 = NULL;
	status = (GetCLASS(Matrix))->CreateRotationMatrix(localX, localY, &mat1);
	CHECK_RETURN_STATUS(status)

	IVector *localOrigin = NULL;
	status = activeWorkplane->GetLocalOrigin(&localOrigin);
	CHECK_RETURN_STATUS(status)

	IMatrix *mat2 = NULL;
	status = (GetCLASS(Matrix))->CreateTranslationMatrix(localOrigin, &mat2);
	CHECK_RETURN_STATUS(status)

	IMatrix *oldmap = NULL;
	status = mat2->MultiplyByMatrix(mat1, &oldmap);
	CHECK_RETURN_STATUS(status)

	double dir1X, dir1Y, dir1Z;
	status = new3X->GetAt(0, &dir1X);
	CHECK_RETURN_STATUS(status)

	status = new3X->GetAt(1, &dir1Y);
	CHECK_RETURN_STATUS(status)

	status = new3X->GetAt(2, &dir1Z);
	CHECK_RETURN_STATUS(status)

	IDirection *dir1 = NULL;
	status = (GetCLASS(Direction))->CreateDirection(dir1X, dir1Y, dir1Z, &dir1);
	CHECK_RETURN_STATUS(status)

	double dir2X, dir2Y, dir2Z;
	status = new3Y->GetAt(0, &dir2X);
	CHECK_RETURN_STATUS(status)

	status = new3Y->GetAt(1, &dir2Y);
	CHECK_RETURN_STATUS(status)

	status = new3Y->GetAt(2, &dir2Z);
	CHECK_RETURN_STATUS(status)

	IDirection *dir2 = NULL;
	status = (GetCLASS(Direction))->CreateDirection(dir2X, dir2Y, dir2Z, &dir2);
	CHECK_RETURN_STATUS(status)

	IMatrix *mat3 = NULL;
	status = (GetCLASS(Matrix))->CreateRotationMatrix(dir1, dir2, &mat3);
	CHECK_RETURN_STATUS(status)

	IMatrix *newmap = NULL;
	status = mat2->MultiplyByMatrix(mat3, &newmap);
	CHECK_RETURN_STATUS(status)

	IMatrix *oldmapInverse = NULL;
	status = oldmap->GetInverse(&oldmapInverse);
	CHECK_RETURN_STATUS(status)

	IMatrix *rotmat = NULL;
	status = newmap->MultiplyByMatrix(oldmapInverse, &rotmat);
	CHECK_RETURN_STATUS(status)

	// Transform the objects
	status = activeWorkplane->TransformObjects(CAST(IObjectOrSet, objectSet1), rotmat);
	CHECK_RETURN_STATUS(status)

	END_METHOD("RotateObjects")
}
